# 05_Graphics
# Purpose: Creating graphics of your data in R
# by Tiziana Li Koch

plot(c(1,2,4,5,7,10),
     main = "A title",
     ylab = "Variable name")

abline(h = 4, 
       col = "red",
       lty = "dashed",
       lwd = 5)




# load data
plot_data <- read.csv("Data/vegetation_survey_fogo.csv")

# Scatter plot
plot(plot_data$Tree_cover, plot_data$Vegetation_cover)

plot(plot_data$Tree_cover, plot_data$Vegetation_cover, pch = 3)

plot(plot_data$Tree_cover, plot_data$Vegetation_cover, 
     pch = 3, col = "blue")



plot(plot_data$Tree_cover, plot_data$Vegetation_cover, 
     pch = 3, 
     col = "blue",
     lwd = 3)



# examples of pch
example(pch)


#examples of colors
colors()
"palevioletred3"
"yellow"
"skyblue3"


# Histogram
hist(plot_data$Vegetation_cover)


hist(plot_data$Vegetation_cover, col = "green")
hist(plot_data$Vegetation_cover, col = "green",
     main = "The Vegetation cover of Plots from Fogo",
    xlab = "Vegetation cover",
    ylim = c(0,60))


# Boxplot
boxplot(Vegetation_cover ~ year, plot_data)
boxplot(Vegetation_cover ~ year, plot_data,
        names = c("Group 2015", "Group 2016")
)

boxplot(Vegetation_cover ~ year, plot_data,
        names = c("Group 2015", "Group 2016"),
        col = c("blue", "darkgreen")
)

# Multiplot
plot(plot_data[, c(8, 9, 10, 16)])


###############
# Graph Add-ons
plot(plot_data$Tree_cover, plot_data$Vegetation_cover, 
     pch = 3, 
     col = "blue",
     lwd = 3)

# lines
abline(v = 20, col = "red")
abline(v = 20, col = "red", lwd = 5)
abline(v = 20, col = "red", lwd = 5, lty = 2)

# text
text(40,15, "A description")
text(40,45, "A description")

###############
# Interactive tools
plot(1:10)
locator()
savethis <- locator()

         

# gives position in data frame of point closest to the clicked position
plot(plot_data$Tree_cover, plot_data$Vegetation_cover, 
     pch = 3, 
     col = "blue",
     lwd = 3)
identify(plot_data$Tree_cover, 
         plot_data$Vegetation_cover)


###############
# Parameter control
par(mfrow = c(1, 2)) # 1 row, 2 cols
hist(plot_data$Tree_cover, col = "red")
hist(plot_data$Vegetation_cover, col = "blue")


# deactivate mode
dev.off()
plot(plot_data$Tree_cover, plot_data$Vegetation_cover, 
     pch = 3, 
     col = "blue",
     lwd = 3)



###############
# Saving graphs
# as pdf
pdf("Data/this_is_a_pdf.pdf")
# run plotting function
hist(plot_data$Tree_cover, col = "red")
# deactivate mode / close pdf writing
dev.off()


png("Data/this_is_a_png.png")
# run plotting function
hist(plot_data$Tree_cover, col = "red")
# deactivate mode / close pdf writing
dev.off()


hist(plot_data$Tree_cover, col = "red")
